/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.ui.wizard.field;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org2.eclipse.php.internal.ui.wizard.field.DialogField;

public class StringDialogField
extends DialogField {
    protected String fText = "";
    protected Text fTextControl;
    protected ModifyListener fModifyListener;
    protected IContentProposalProvider fContentAssistProcessor;
    protected ContentProposalAdapter contentProposalAdapter;
    protected LabelProvider labelProvider;

    public void setContentAssistLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public IContentProposalProvider getFContentAssistProcessor() {
        return this.fContentAssistProcessor;
    }

    public void setFContentAssistProcessor(IContentProposalProvider contentAssistProcessor) {
        this.fContentAssistProcessor = contentAssistProcessor;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(parent);
        text.setLayoutData((Object)StringDialogField.gridDataForText(nColumns - 1));
        return new Control[]{label, text};
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    protected static GridData gridDataForText(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setFocus();
            this.fTextControl.setSelection(0, this.fTextControl.getText().length());
        }
        return true;
    }

    public Text getTextControl(Composite parent) {
        if (this.fContentAssistProcessor != null) {
            DecoratedField fld = new DecoratedField(parent, 0, new IControlCreator(){

                public Control createControl(Composite parent, int style) {
                    StringDialogField.this.createText(parent);
                    return StringDialogField.this.fTextControl;
                }
            });
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            fld.addFieldDecoration(fieldDecoration, 16512, true);
            fld.showDecoration(fieldDecoration);
            KeyStroke keyStroke = KeyStroke.getInstance((int)262144, (int)32);
            this.contentProposalAdapter = new ContentProposalAdapter((Control)this.fTextControl, (IControlContentAdapter)new TextContentAdapter(), this.fContentAssistProcessor, keyStroke, null);
            this.contentProposalAdapter.setProposalAcceptanceStyle(2);
            this.contentProposalAdapter.setLabelProvider((ILabelProvider)this.labelProvider);
            return this.fTextControl;
        }
        this.createText(parent);
        return this.fTextControl;
    }

    private void createText(Composite parent) {
        if (this.fTextControl == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringDialogField.this.doModifyText(e);
                }
            };
            this.fTextControl = new Text(parent, 2052);
            this.fTextControl.setText(this.fText);
            this.fTextControl.setFont(parent.getFont());
            this.fTextControl.addModifyListener(this.fModifyListener);
            this.fTextControl.setEnabled(this.isEnabled());
        }
    }

    protected void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fText = this.fTextControl.getText();
        }
        this.dialogFieldChanged();
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setEnabled(this.isEnabled());
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.removeModifyListener(this.fModifyListener);
            this.fTextControl.setText(text);
            this.fTextControl.addModifyListener(this.fModifyListener);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.setTextWithoutUpdate(this.fText);
        }
    }
}

